jQuery(document).ready(function ($) {
    $('#draw_cards').on('click', function () {
        var name = $('#user_name').val().trim();
        var mobile = $('#user_mobile').val().trim();
        var question = $('#user_question').val().trim();
        var $result = $('#tarot_result');

        // بررسی اولیه
        if (!name || !mobile || !question) {
            $result.html('<div class="error">⚠️ لطفاً تمام فیلدها را پر کنید.</div>');
            return;
        }

        // دکمه غیرفعال نشود چندبار
        $('#draw_cards').prop('disabled', true).text('در حال پردازش...');

        // نمایش پیام اولیه
        $result.html('<div class="loading">🔮 در حال گرفتن فال...</div>');

        // ارسال Ajax
        $.post(ai_tarot_ajax.ajax_url, {
            action: 'ai_tarot_get_reading',
            name: name,
            mobile: mobile,
            question: question
        }, function (response) {
            $('#draw_cards').prop('disabled', false).text('گرفتن فال');
            
            if (response.success) {
                $result.html(response.data.reading);
            } else {
                $result.html('<div class="error">⚠️ ' + response.data + '</div>');
            }
        }).fail(function () {
            $('#draw_cards').prop('disabled', false).text('گرفتن فال');
            $result.html('<div class="error">❌ خطا در ارتباط با سرور. لطفاً دوباره تلاش کنید.</div>');
        });
    });
});
